/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_05; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class GetSessionDemo {
	static String host = "www.djbuch.de",
		user = "Thomas Ekert/DJBUCH", pwd = "geheim";
	static final String [] args = new String [1];
	static {args [0] = "-ORBEnableSSLSecurity";}
	private Database db = null; private Session session=null;
	
	public static void main(String argv[]) {
		GetSessionDemo gsd = new GetSessionDemo();
		gsd.doJob();
	}
	
	private Session getSession () throws NotesException {
		if (session == null || !session.isValid()) {
			session = NotesFactory.createSession(host, args, user, pwd);
		} 
		return session;
	}
	
	private void doJob () {
		try {
			//Der erste Aufruf von getSession() wird die session aufbauen.
			printInfo(getSession());
			//Sptere Aufrufe von getSessoin () werden die session nur dann aufbauen,
			//wenn sie zwischenzeitlich serverseitig aufgerumt wurde.
			db = getSession ().getDatabase("","djbuch/djbuch.nsf");
		} catch (NotesException e) {
			System.err.println ("Notes Error Number: " + e.id);
			e.printStackTrace();
		} finally {
			recycleMe();
		}
	} 
	private void recycleMe () {
		try {
			if (db != null) {db.recycle();}
			if (session != null && session.isValid()) {
				session.recycle ();
			}
		} catch (NotesException e) {
			e.printStackTrace();
		} catch (org.omg.CORBA.INV_OBJREF e) {
			//ignore
		}
	}
	private static void printInfo(Session s)
		throws NotesException {
		System.out.println ("SessionClass\t= " + s.getClass().getName());
		System.out.println ("Platform\t\t= " + s.getPlatform());
		System.out.println ("Version\t\t\t= " + s.getNotesVersion());
		System.out.println ("User\t\t\t= " + s.getUserName());
		System.out.println ("Session Token\t= " + s.getSessionToken());
		System.out.println ("Servername\t\t= <<" + s.getServerName() + ">>\n");	
	}
	
	
}